*** Settings ***
Resource            /opt/robot-tests/tests/resources/common.resource
Resource            /opt/robot-tests/tests/resources/api_invoker_management_requests/apiInvokerManagementRequests.robot
Resource            ../../resources/common.resource
Library             /opt/robot-tests/tests/libraries/bodyRequests.py

Suite Teardown      Reset Testing Environment
Test Setup          Reset Testing Environment
Test Teardown       Reset Testing Environment


*** Variables ***
${API_INVOKER_NOT_REGISTERED}       not-valid


*** Test Cases ***
Vendor Extensibility published with vendorExt active
    [Tags]    vendor_extensibility-1
    ${vendor_specific_service_api_key}=   Set Variable   vendorSpecific-urn:etsi:mec:capifext:service-info
    ${vendor_specific_aef_profile_key}=   Set Variable   vendorSpecific-urn:etsi:mec:capifext:transport-info
    # Register APF
    ${register_user_info}=    Provider Default Registration

    # Create Vendor Specific information
    ${vendor_specific_service_api_description}=    Create Vendor Specific Service Api Description
    ...    ${vendor_specific_service_api_key}
    ${vendor_specific_aef_profile}=    Create Vendor Specific Aef Profile
    ...    ${vendor_specific_aef_profile_key}

    # Publish one api
    ${service_api_description_published}    ${resource_url}    ${request_body}=    Publish Service Api
    ...    ${register_user_info}
    ...    supported_features=100
    ...    vendor_specific_service_api_description=${vendor_specific_service_api_description}
    ...    vendor_specific_aef_profile=${vendor_specific_aef_profile}

    Dictionary Should Contain Key    ${service_api_description_published}    ${vendor_specific_service_api_key}
    Dictionary Should Contain Key    ${service_api_description_published['aefProfiles'][0]}    ${vendor_specific_aef_profile_key}

    # Default Invoker Registration and Onboarding
    ${register_user_info_invoker}    ${url}    ${request_body}=    Invoker Default Onboarding

    # Test
    ${resp}=    Get Request Capif
    ...    ${DISCOVER_URL}${register_user_info_invoker['api_invoker_id']}&aef-id=${register_user_info['aef_id']}
    ...    server=${CAPIF_HTTPS_URL}
    ...    verify=ca.crt
    ...    username=${INVOKER_USERNAME}

    Check Response Variable Type And Values    ${resp}    200    DiscoveredAPIs

    # Check Results
    Dictionary Should Contain Key    ${resp.json()}    serviceAPIDescriptions
    Should Not Be Empty    ${resp.json()['serviceAPIDescriptions']}
    Length Should Be    ${resp.json()['serviceAPIDescriptions']}    1
    List Should Contain Value    ${resp.json()['serviceAPIDescriptions']}    ${service_api_description_published}


Vendor Extensibility published with vendorExt not active
    [Tags]    vendor_extensibility-2
    ${vendor_specific_service_api_key}=   Set Variable   vendorSpecific-urn:etsi:mec:capifext:service-info
    ${vendor_specific_aef_profile_key}=   Set Variable   vendorSpecific-urn:etsi:mec:capifext:transport-info
    # Register APF
    ${register_user_info}=    Provider Default Registration

    # Create Vendor Specific information
    ${vendor_specific_service_api_description}=    Create Vendor Specific Service Api Description
    ...    ${vendor_specific_service_api_key}
    ${vendor_specific_aef_profile}=    Create Vendor Specific Aef Profile
    ...    ${vendor_specific_aef_profile_key}

    # Publish one api
    ${service_api_description_published}    ${resource_url}    ${request_body}=    Publish Service Api
    ...    ${register_user_info}
    ...    supported_features=000
    ...    vendor_specific_service_api_description=${vendor_specific_service_api_description}
    ...    vendor_specific_aef_profile=${vendor_specific_aef_profile}

    Dictionary Should Not Contain Key    ${service_api_description_published}    ${vendor_specific_service_api_key}
    Dictionary Should Not Contain Key    ${service_api_description_published['aefProfiles'][0]}    ${vendor_specific_aef_profile_key}

    # Default Invoker Registration and Onboarding
    ${register_user_info_invoker}    ${url}    ${request_body}=    Invoker Default Onboarding

    # Test
    ${resp}=    Get Request Capif
    ...    ${DISCOVER_URL}${register_user_info_invoker['api_invoker_id']}&aef-id=${register_user_info['aef_id']}
    ...    server=${CAPIF_HTTPS_URL}
    ...    verify=ca.crt
    ...    username=${INVOKER_USERNAME}

    Check Response Variable Type And Values    ${resp}    200    DiscoveredAPIs

    # Check Results
    Dictionary Should Contain Key    ${resp.json()}    serviceAPIDescriptions
    Should Not Be Empty    ${resp.json()['serviceAPIDescriptions']}
    Length Should Be    ${resp.json()['serviceAPIDescriptions']}    1
    List Should Contain Value    ${resp.json()['serviceAPIDescriptions']}    ${service_api_description_published}